#!/bin/sh

MODEL=$1
CURDIR=$2
ROOTDIR=$3
VERSION=$4
PRODUCT=$5
modelName=`echo $MODEL | tr '[A-Z]' '[a-z]'`
  
rm -rf default
mkdir default
ln -s $2/../html/skins/genie_ext/languages/default/* ./default/

if [ -d $ROOTDIR/build/romfs/files_for_language_server ];then
rm $ROOTDIR/build/romfs/files_for_language_server -rf
fi

mkdir $ROOTDIR/build/romfs/files_for_language_server

IMG_MD5VALUE=`md5sum $ROOTDIR/build/romfs/$PRODUCT.img| cut -d ' ' -f  1`
IMG_SIZE=`ls -l $ROOTDIR/build/romfs/$PRODUCT.img| cut -d ' ' -f 5`
echo [Major1] >> $ROOTDIR/build/romfs/files_for_language_server/fileinfo.txt
echo file=/$modelName/us/$MODEL-V$VERSION.img >> $ROOTDIR/build/romfs/files_for_language_server/fileinfo.txt
echo md5=`echo $IMG_MD5VALUE | tr '[a-z]' '[A-Z]'`>> $ROOTDIR/build/romfs/files_for_language_server/fileinfo.txt
echo size=$IMG_SIZE>> $ROOTDIR/build/romfs/files_for_language_server/fileinfo.txt


#stringtable flag create
#n1.c<n>.r<n>.o<n> => n1.n2.n3.n4 => 1.0.0.1
######################################################################################
#example:
#echo "o1=<MSG001>" >> $ROOTDIR/build/romfs/files_for_language_server/fileinfo.txt
#echo "r1=<MSG102>" >> $ROOTDIR/build/romfs/files_for_language_server/fileinfo.txt
#echo "c1=<MSG203>" >> $ROOTDIR/build/romfs/files_for_language_server/fileinfo.txt
######################################################################################
#ϢNETGEARĿУҪɾ

#echo "o1=<MSG001>" >> $ROOTDIR/build/romfs/files_for_language_server/fileinfo.txt
#echo "o2=<MSG002>" >> $ROOTDIR/build/romfs/files_for_language_server/fileinfo.txt
#echo "o3=<MSG003>" >> $ROOTDIR/build/romfs/files_for_language_server/fileinfo.txt
#
#echo  >> $ROOTDIR/build/romfs/files_for_language_server/fileinfo.txt
for file in $CURDIR/*
do
bfile=`basename $file`
#if [ -f $file ];then
#echo isfile
if [ -d  $file ];then
bfile=`basename $file`
cd $file/
#echo $VERSION > "$bfile"
#echo $VERSION > "fileinfo"
#echo "$bfile" >> "fileinfo"
tar -czhf $MODEL-$bfile.tar.gz ./*
mv $MODEL-$bfile.tar.gz $MODEL-V$VERSION-$bfile.tar.gz 
cp $MODEL-V$VERSION-$bfile.tar.gz $ROOTDIR/build/romfs/files_for_language_server/
#MD5VALUE=`md5sum $MODEL-V$VERSION-$bfile.tar.gz| cut -d ' ' -f  1`
#SIZE=`ls -l $MODEL-V$VERSION-$bfile.tar.gz| cut -d ' ' -f 5`
rm $MODEL-V$VERSION-$bfile.tar.gz
#echo [$MODEL-$bfile-language-table] >> $ROOTDIR/build/romfs/files_for_language_server/fileinfo.txt
#echo file=/$modelName/ww/$MODEL-V$VERSION-$bfile.tar.gz>> $ROOTDIR/build/romfs/files_for_language_server/fileinfo.txt
#echo md5=`echo $MD5VALUE | tr '[a-z]' '[A-Z]'`>> $ROOTDIR/build/romfs/files_for_language_server/fileinfo.txt
#echo size=$SIZE>> $ROOTDIR/build/romfs/files_for_language_server/fileinfo.txt
#echo >> $ROOTDIR/build/romfs/files_for_language_server/fileinfo.txt
cd -
fi
done

iconv  -f UTF-8 -t Unicode $ROOTDIR/build/romfs/files_for_language_server/fileinfo.txt > $ROOTDIR/build/romfs/files_for_language_server/fileinfo1.txt
rm -rf $ROOTDIR/build/romfs/files_for_language_server/fileinfo.txt
mv $ROOTDIR/build/romfs/files_for_language_server/fileinfo1.txt $ROOTDIR/build/romfs/files_for_language_server/fileinfo.txt

#pelease know it, the each line of the stringtable.dat can't bigger then 500 words
cp $ROOTDIR/src/apps/language_patches/stringtable.dat $ROOTDIR/build/romfs/files_for_language_server/stringtable.dat

#######################################################################################
##						Make language packages for web upgrading					 #
#######################################################################################
max_allow_lang_pack_num=5
pack_count=0
lang_pack_name="$MODEL-V$VERSION"
lang_pack_list=""
for name in `cat $ROOTDIR/src/apps/language_patches/upgrade_lang_packages`
do
if [ "${pack_count}" -lt "${max_allow_lang_pack_num}" ]; then
lang_pack_name+="-${name}"
lang_pack_list+="${MODEL}-V${VERSION}-${name}.tar.gz "
fi
let pack_count++
done

cd files_for_language_server
tar -czf ${lang_pack_name}.tar.gz ${lang_pack_list}
cd -

